<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\Category;
use App\Models\Brand;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $categories = Category::all();
        $brands = Brand::all();

        foreach ($categories as $category) {
            foreach ($brands as $brand) {
                Product::factory()->count(10)->create([
                    'category_id' => $category->id,
                    'brand_id' => $brand->id,
                ]);
            }
        }
    }
}